﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucPatLookup.ascx.cs" Inherits="ucPatLookup" %>
<%@ Register Assembly="Ext.Net" Namespace="Ext.Net" TagPrefix="ext" %>

<style type="text/css">
    .lookup-lnk
    {
        color: #000;
        text-decoration: underline;
    }

</style>
<script type="text/javascript">
    
    function AriaPatSrchBtn(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaDopatLkBtn(el) {
        el.set({
            "role": 'button'
        });
    }
    
    function AriaDopatCansLkBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    
</script>


<ext:Window ID="winPatLookup"
    runat="server"
    Title="Patient Lookup"
    Icon="MagnifierZoomIn"
    AutoDoLayout="true"
    MaintainFlex="true"
    Width="630"
    Height="500"
    Padding="5"
    Hidden="true"
    IDMode="Static"
    Layout="BorderLayout"
    Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn"
    >
    <Listeners>
        <BeforeHide Handler="App.direct.PATLOOKUP.InitializeLookupWindow(); return true;" />
        <Show Handler="Ext.defer(function() {App.winPatLookup.focus(false, 100);}, 1);Ext.defer(function() {App.txtSearch.focus(false, 100);}, 1);" />
    </Listeners>
    <Items>
        <ext:FormPanel ID="frmLookupCriteria"
            runat="server"
            Region="North"
            MinHeight="40"
            Layout="VBoxLayout"
            Border="false"
            DefaultButton="btnSearch">
            <LayoutConfig>
                <ext:VBoxLayoutConfig Align="Stretch"></ext:VBoxLayoutConfig>
            </LayoutConfig>
            <Items>
                <ext:Container runat="server"
                    Height="40"
                    Layout="HBoxLayout">
                    <LayoutConfig>
                        <ext:HBoxLayoutConfig Pack="Start" Align="Middle"></ext:HBoxLayoutConfig>
                    </LayoutConfig>
                    <Items>
                        <ext:TextField ID="txtSearch" FieldLabel="Criteria" LabelWidth="40"
                            runat="server"
                            Width="190"
                            Margins="0 5 0 0"
                            Padding="4"  
                            Vtype="alphanum">
                            <Plugins>
                                <ext:InputMask ID="inpMskSearch" runat="server" Mask="a9999" Enabled="false" AllowInvalid="true" ClearWhenInvalid="false">
                                    <MaskSymbols>
                                        <ext:MaskSymbol Name="a" Regex="[a-zA-Z]" />
                                    </MaskSymbols>
                                </ext:InputMask>
                            </Plugins>
                            <Listeners>
                                <Change Fn="enableSearch" />
                            </Listeners>
                        </ext:TextField>
                        <ext:Button ID="btnSearch"
                            runat="server"
                            Text="Search"
                            Icon="Magnifier"
                            Margins="0 10 0 0">
                            <Listeners>
                                <AfterRender Handler="AriaPatSrchBtn(App.btnSearch.getEl());" ></AfterRender>
                                <Click Handler="App.direct.PATLOOKUP.LookupPatient({ success: clearLookupStatusDiv(3) })">
                                </Click>
                            </Listeners>
                        </ext:Button>
                        <ext:RadioGroup ID="rblSearchType"
                            runat="server"
                            GroupName="rblSearchType">
                            <Items>
                                  
                                <ext:Radio ID="radLastName"
                                    runat="server"
                                    InputValue="1" Name="rdssso1"
                                    Checked="true"
                                    Selectable="true"
                                    Width="90"
                                    BoxLabel="Last Name"
                                    >
                                </ext:Radio>
                                <ext:Radio ID="radLast4SSN"
                                    runat="server" Name="rdssso1"
                                    InputValue="3"
                                    Selectable="true"
                                    Width="125"
                                    BoxLabel="L.I. + Last 4 SSN"
                                    >
                                </ext:Radio>
                                
                            </Items>
                            <Listeners>
                                <Change Fn="changeSearchType" />
                            </Listeners>
                        </ext:RadioGroup>
                    </Items>
                </ext:Container>
                <ext:Container ID="divPatLookupStatus" 
                    runat="server"
                    MinHeight="20" 
                    Hidden="true" 
                    Border="true">
                    <Content>
                        <div style="text-align: left; margin: 2px auto 2px auto; padding: 3px; font-weight: bold;">
                            <font color="blue"><img alt="No Records Found" src="Images/table_delete.png" >&nbsp;No records found!</font>
                        </div>
                    </Content>
                </ext:Container>
            </Items>
        </ext:FormPanel>
        <ext:GridPanel ID="gpPatientLookup"
            IDMode="Static"
            runat="server"
            Region="Center"
            Flex="1" Border="false"
            AnchorHorizontal="100%"
            AnchorVertical="100%"
            AutoScroll="true"
            StripeRows="true"
            TrackMouseOver="true"
            Layout="FitLayout">
            <Store>
                <ext:Store ID="sPatientLookup" IDMode="Static" runat="server">
                    <Model>
                        <ext:Model ID="mdlPatientLookup" runat="server">
                            <Fields>
                                <ext:ModelField Name="patient_id" />
                                <ext:ModelField Name="lnssnlast4" />
                                <ext:ModelField Name="last_name" />
                                <ext:ModelField Name="first_name" />
                                <ext:ModelField Name="birthdate" />
                                <ext:ModelField Name="gender" />
                                <ext:ModelField Name="patient_age" Type="Int" />
                            </Fields>
                        </ext:Model>
                    </Model>
                </ext:Store>
            </Store>
            <ColumnModel ID="cmPatientLookup" IDMode="Static" runat="server">
                <Columns>
                    <ext:CommandColumn runat="server" Width="35" Align="Center">
                        <Commands>
                            <ext:GridCommand CommandName="LOOKUP_PATIENT" Icon="Magnifier" ToolTip-Text="Lookup" />
                        </Commands>
                        <Listeners>
                            <Command Handler="fnLookup(command, record.data.patient_id)" />
                        </Listeners>
                    </ext:CommandColumn>
                    <ext:TemplateColumn Header="LSSN" DataIndex="lnssnlast4" Flex="15" runat="server">
                        <Template runat="server">
                            <Html>
                                <a href="#" onclick="fnLookup('LOOKUP_PATIENT','{patient_id}')" class="lookup-lnk">{lnssnlast4}</a>
                            </Html>
                        </Template>
                    </ext:TemplateColumn>
                    <ext:Column runat="server" Header="Last Name" DataIndex="last_name" Flex="23" />
                    <ext:Column runat="server" Header="First Name" DataIndex="first_name" Flex="23" />
                    <ext:Column runat="server" Header="DOB" DataIndex="birthdate" Flex="17" />
                    <ext:Column runat="server" Header="Age" DataIndex="patient_age" Flex="11" />
                    <ext:Column runat="server" Header="Gender" DataIndex="gender" Flex="11" />
                </Columns>
            </ColumnModel>
            <SelectionModel>
                <ext:RowSelectionModel ID="rsmPatientLookup" IDMode="Static" runat="server" SingleSelect="true" />
            </SelectionModel>
            </ext:GridPanel>
    </Items>
    <BottomBar>
        <ext:Toolbar runat="server">
        <Items>
            <ext:Button ID="btnDoPatLookup" runat="server" Text="Select Patient" Icon="Magnifier" Handler="fnLookup('LOOKUP_PATIENT', App.gpPatientLookup.getSelectionModel().getSelection()[0].data.patient_id )" >
            <Listeners>
                <AfterRender Handler="AriaDopatLkBtn(App.btnDoPatLookup.getEl());" ></AfterRender>
            </Listeners>
            </ext:Button>

            <ext:Button ID="btnCancelPatLookup" runat="server" Text="Cancel" Icon="Cancel" Handler="App.winPatLookup.hide();" >
            <Listeners>
                <AfterRender Handler="AriaDopatCansLkBtn(App.btnCancelPatLookup.getEl());" ></AfterRender>
            </Listeners>
            </ext:Button>
        </Items>
        </ext:Toolbar>
        </BottomBar>
</ext:Window>

<script>
    //clear search results message
    var clearLookupStatusDiv = function (delaySecs) {
        Ext.onReady(function () {
            var divPatLookupStatus = Ext.getCmp('divPatLookupStatus');
            var clDivLookup = setTimeout(function () {
                if (typeof (divPatLookupStatus) === "object") {
                    divPatLookupStatus.hide();
                }
            }, delaySecs * 1000);
        });
    },

    renderFMP = function (value, meta, record) {
        var pat_id = record.data.patient_id;
        var fmp = record.data.fmpssnlast4;

        return String.format(
        '<a href="#null" onclick=\'myMask.show(); OnGVLinkClick("gvPatients", "FMP Last 4", "fmplast4", "{2}", "{1}")\'; return false;>{0}</a>',
        value, pat_id, fmp);
    },

    renderLastName = function (value, meta, record) {
        var pat_id = record.data.patient_id;
        var lastname = record.data.last_name;

        return String.format(
        '<a href="#null" onclick=\'OnGVLinkClick("gvPatients", "Last Name", "last_name", "{2}", "{1}")\'; return false;>{0}</a>',
        value, pat_id, lastname);
    },

    changeSearchType = function () {
        if (App.radLastName.value == true) {
            App.txtSearch.inputMask.disable();
            App.txtSearch.vtype = "alphanum";
        }
        else {
            App.inpMskSearch.enable();
            App.txtSearch.vtype = "lnil4SSN";
        }
    },

    enableSearch = function () {
        App.btnSearch.setDisabled(!App.txtSearch.isValid());
    },

    fnLookup = function (command, patient_id) {
        switch (command) {
            case "LOOKUP_PATIENT":
                App.direct.BSMASTER.LookupPatient(true, patient_id, {
                    success: function () {
                        App.winPatLookup.mask();
                        //myMask.show();
                    }
                });
                break;
        }
    },

    fnPrepareLookup = function (grid, toolbar, rowIndex, record) {
        var firstButton = toolbar.items.get(0);
        firstButton.setText(record.data.lnssnlast4);
    };
    
    $(document).ready(function () {
        Ext.onReady(function ()
        {
            App.txtSearch.inputMask.disable();
            
        });
    });
</script>
